* gof_clerids.sas;
options pageno=1 linesize=80;
title 'Goodness-of-fit test for T. dubius data';
data elytra;
	input sex $ obsfreq;
	datalines;
F  60
M  70
;
run;
* Print data set;
proc print data=elytra;
run;
* Goodness-of-fit test (Chi-square only);
proc freq data=elytra order=data;
	tables sex / testp=(0.5 0.5) chisq cellchi2 expected;
	weight obsfreq;
	* Compute exact test if frequencies low, takes too long for large data sets;
	exact chisq;
run;
quit;
